define(['HealthMoodRemindersService', 'HealthMoodRemindersInstanceService'], function () {
	'use strict';

	describe('Health-Mood Reminders Service', function () {
		var scope,
			state,
			q,
			service,
			serviceMock,
			serviceSaveSpy,
			serviceFetchSpy,
			serviceCreateEmptySpy,
			myRemindersCreateEmptyMock = {
				date: "date",
				remind: "me"
			},
			keyMock = 'glucose',
			sectionTitleMock = 'Mock Section Title';

		beforeEach(function() {
			module('angularTemplateApp');

			serviceMock = jasmine.createSpyObj('HealthMoodRemindersInstanceService', ['instance', 'fetch, createEmpty, save']);
			serviceSaveSpy = jasmine.createSpy("serviceSaveSpy").and.returnValue({then: function () {}});
			serviceFetchSpy = jasmine.createSpy("serviceFetchSpy").and.returnValue({then: function () {}});
			serviceCreateEmptySpy = jasmine.createSpy("serviceCreateEmptySpy").and.returnValue(myRemindersCreateEmptyMock);

			serviceMock.instance.and.returnValue({
				createEmpty: serviceCreateEmptySpy,
				save: serviceSaveSpy,
				fetch: serviceFetchSpy
			});

			module(function($provide) {
				$provide.value('HealthMoodRemindersInstanceService', serviceMock);
			});

			inject(function($rootScope, $q, $state, HealthMoodRemindersService) {
				scope = $rootScope.$new();
				q = $q;
				state = $state;

				$state.current = {
					data: {
						paramSections: [
							{
								paramValue: keyMock,
								sectionName: sectionTitleMock
							}
						]
					}
				};

				service = HealthMoodRemindersService;
			});
		});

		describe('methods', function () {
			it('should exist', function () {
				expect(service.init).toBeDefined();
				expect(service.getReminder).toBeDefined();
				expect(service.save).toBeDefined();
			});

			it('get reminder data - with response size > 0', function() {
				var deferred = q.defer(),
					mockData = {
						size: 1,
						reminders: ["reminder_data"]
					};

				deferred.resolve(mockData);
				serviceFetchSpy.and.returnValue(deferred.promise);
				service.init(keyMock);

				service.getReminder(sectionTitleMock).then(function(response) {
					expect(response).toEqual(mockData.reminders[0]);
				}).finally(function() {
					expect(deferred.state()).toBe("resolved");
				});
				scope.$apply();

				expect(serviceFetchSpy).toHaveBeenCalled();
			});

			it('get reminder data - with response size == 0', function() {
				var deferred = q.defer(),
					mockData = {
						size: 0
					};

				deferred.resolve(mockData);
				serviceFetchSpy.and.returnValue(deferred.promise);
				service.init(keyMock);

				service.getReminder(sectionTitleMock).then(function(response) {
					expect(response).toEqual(myRemindersCreateEmptyMock);
				}).finally(function() {
					expect(deferred.state()).toBe("resolved");
				});
				scope.$apply();

				expect(serviceFetchSpy).toHaveBeenCalled();
			});

			it('save data', function() {
				var deferred = q.defer(),
					mockData = {
						remind: "me",
						date: "date",
						notificationStatus: "On"
					},
					subjectMock = 'Update your ' + sectionTitleMock + ' information now.',
					bodyMock = '<br/>This notice is provided to help you remember to update your ' + sectionTitleMock + ' information.<br/><br/>',
					finalMockData = {
						remind: "me",
						date: "date",
						notificationStatus: "On",
						title: subjectMock,
						healthTrackerId: keyMock,
						auxData: [
							{key: "emailSubject", value: subjectMock},
							{key: "emailBody", value: bodyMock},
							{key: "emailUpdateMessage", value: 'Update this information in the {appLink}<br/><br/>To modify or stop future notices, update the Notification settings for this Health feature inside the VA FitHeart App.'},
							{key: "emailSignature", value: "FitHeart - Health"},
							{key: 'source', value : 'HEART'},
							{key: "appName", value: "fit-heart"},
							{key: "appUri", value: "fit-heart"}
						]
					};

				deferred.resolve({});
				service.init(keyMock);

				service.save(mockData).finally(function() {
					expect(deferred.state()).toBe("resolved");
				});
				scope.$apply();

				expect(serviceSaveSpy).toHaveBeenCalledWith(finalMockData);
			});
		});
	});
});